<?php

defined('BASEPATH') OR exit('No direct script access allowed');
include("library/cpanelupi/CpanelManager.php");

/**
 *
 * @property CI_Input input
 * @property CI_Session session
 * @property CI_Form_validation form_validation
 * @property StoreModel StoreModel
 */
class CreateSiteCronController extends CI_Controller {

   public function __construct(){

        parent:: __construct();
        $this->load->model('StoreModel');
        //$this->SingleSiteCreate();
    }


    
    /**
     * Function: SingleSiteCreate
     *
     * This function fetches Single Site records having statuses as ready_create_store
     *
     * @param : null
     *
     * @return : null
     */
    public function SingleSiteCreate(){

        $status = $this->StoreModel->getData('statuses',array('slug'=>'ready_create_store'));
        $status_id = $status[0]['id'];
        $records = $this->StoreModel->getData('records',array('statuses_id' => $status_id));

        if (empty($records)) {

            echo 'Records empty';
            die();
        }
     
        foreach ($records as $record) {
            
            // mark record as processing  
            $this->_processData($record);
            
            $set_status = array('statuses_id'=> 2);
            
            $this->StoreModel->updateData($record['id'],'records',$set_status);
        }

    }

   

   /**
    * Function: _processData
    *
    * This function will fetch Single Site records having statuses as ready_create_store and all it's
    * related data like:- wordpress_data,theme_data,cpanel_data etc.
    * connect cpanel account, process wordpress database then process wordpress theme
    * and execute cell command for create blog post
    *
    * @param : record
    *
    * @return : null
   */
   public function _processData($record)
   {
        $id = $record['id'];
        $cpanel_id = $record['cpanel_id'];
        $user_id = $record['user_id'];
        $wordpress_id = $record['wordpress_id'];
        $theme_id = $record['theme_id'];
        $button_id = $record['button_id'];

        $data = array('id' => $cpanel_id);  

        $cpanel_data = $this->StoreModel->getData('cpanel',$data);  
        $user_data = $this->StoreModel->getData('users',array('id'=>$user_id)); 
        $wordpress_data = $this->StoreModel->getData('wordpress',array('id'=>$wordpress_id)); 
        $wordpress_data1 = $this->StoreModel->getData('wordpress',array('id'=>$wordpress_id));
        $theme_data = $this->StoreModel->getData('themes',array('id'=>$theme_id));
        $button_data = $this->StoreModel->getData('buttons',array('id'=>$button_id));

        $cpanel_username = $cpanel_data[0]['username']; 
        $cpanel_password = $cpanel_data[0]['password'];  
        $cpanel_domain = $cpanel_data[0]['domain'];  
        $cpanel_installation_path = $record['installation_path'];  

        try {
            $cpanel = new CpanelManager($cpanel_username,$cpanel_password,$cpanel_domain);


            //process database for wordpress site
            $wordpress_data = $cpanel->processDatabase($user_data, $wordpress_data, $cpanel_data, $theme_data, $cpanel_installation_path);
            
            //get update $wordpress_data variable
            $response_wordpress = array(
                'db_username'=>$wordpress_data[0]['db_username'],
                'db_name'=>$wordpress_data[0]['db_name']
            );
            
            $this->StoreModel->updateData($wordpress_id,'wordpress',$response_wordpress);
            
            
            //process wodrpress file
            $cpanel->processWordpress($wordpress_data, $cpanel_installation_path);
            $cpanel->processTheme($theme_data,$cpanel_installation_path);

            if($theme_data[0]['recommend'] == 1)
            {  

                $explode = explode('.',$theme_data[0]['file']);
                $theme_name = $explode[0];  //get theme type for recommend theme as 1

                $cpanel->themeFile($wordpress_data1, $cpanel_installation_path,$theme_name);

            }
            
            $command = "php ".FCPATH."index.php CreatePostCronController singleSitePost > /dev/null &";
            exec($command);

        } catch(Exception $e) {
            print_r($e);
            $this->StoreModel->markFailed(
                'records',
                $record['id'],
                $e->getMessage()
            );

        }
    }



}
