<?php

defined('BASEPATH') OR exit('No direct script access allowed');
use TBETool\PasswordGenerator;
include("library/wordpress/WordpressManager.php");

/**
 * @property  StoreModel StoreModel
 * @property  Membershipmodel Membershipmodel
 * @property WordpressManager WordpressManager
 */
class CreatePostCronController extends CI_Controller{
    
    function __construct(){
        parent:: __construct();
        //$this->singleSitePost();

        $this->load->library('Envato');

        $this->load->model('StoreModel');
        $this->load->model('Membershipmodel');
     }

    
    /**
     * Function: singleSitePost
     *
     * This function fetches all single site records having statuses as processing_data
     *
     * @param : null
     *
     * @return : null
     */
    public function singleSitePost(){
      
          $status = $this->StoreModel->getData('statuses',array('slug'=>'processing_data'));
          $status_id = $status[0]['id'];
          $records = $this->StoreModel->getData('records',array('statuses_id' => $status_id)); 

       foreach ($records as $record){
            
            try {

                     $this->processPost($record);
                     $set_status = array('statuses_id'=> 3);
                     $this->StoreModel->updateData($record['id'],'records',$set_status);

                } catch (Exception $exception) {
                
                     $this->StoreModel->markFailed('records', $record['id'], $exception->getMessage());
                }
            } 
     }

   

       
    /**
     * Function: processPost
     *
     * This function will fetches all single site records having statuses as processing_data
     * get all current site records and connect wordpress account or call a post function to post
     *
     * @param : record
     *
     * @return : null
    */
     private function processPost($record){

        $id = $record['id'];    
        $cpanel_id = $record['cpanel_id'];  
        $envato_id = $record['envato_id'];
        $amazon_id = $record['amazon_id'];
        $buttons_id = $record['button_id'];
        $wordpress_id = $record['wordpress_id'];    
        $installation_path = $record['installation_path'];  
        $data = array('id' => $cpanel_id);   
        $cpanel_data = $this->StoreModel->getData('cpanel',$data);
        $amazon_data = $this->StoreModel->getData('amazon',array('id'=>$amazon_id));
        $wordpress_data = $this->StoreModel->getData('wordpress',array('id'=>$wordpress_id));
        $buttons_data   = $this->StoreModel->getField('name','buttons',$buttons_id);


        //cPanel Deatils
        $cpanel_username = $cpanel_data[0]['username'];       
        $cpanel_password = $cpanel_data[0]['password'];    
        $cpanel_domain = $cpanel_data[0]['domain'];


        try {

            $wp = new WordpressManager($wordpress_data[0]['db_username'],
                                        $wordpress_data[0]['db_password'],
                                        $wordpress_data[0]['db_name']
                                     );
           
          
           $wp->setupCpanel($cpanel_username, $cpanel_password, $cpanel_domain);

           if($this->StoreModel->updateData($id,'categories',array('status'=>2))){


               try{
                   $this->Post($wp, $cpanel_data,$amazon_data,$buttons_data,$id,$installation_path);
                   $date = Date('Y-m-d H:i:s');
                   $this->StoreModel->updateData($id,'categories',array('status'=>3,'modified'=>$date));

               }catch(Exception $e){
                   $this->StoreModel->markFailed('records', $id, $e->getMessage());
               }

           }


          } catch(Exception $e) {

              throw new Exception($e->getMessage());
         }
     }

    
    
     /**
      * Function: Post
      *
      * This function will take five arrguments to create post wordpress connection object, cpanel details,
      * user selected buttons data, current records table id, theme installation path
      * before creating post it also check video type is custom or auto
      * if auto- function fetch random products against keywords
      * if custom- function fetch user's selected post and post on wordpress blog
      *
      * @param : wp,cpanel_data,button_data,id,installation_path
      *
      * @return : null
     */
     private function Post($wp, $cpanel_data,$amazon_data,$buttons_data,$id,$installation_path) {

          $data['record'] = $this->StoreModel->getRecords(array('id'=>$id));

          // Amazon Records
         $amazon_id = $data['record'][0]['amazon_id'];

         $amazon['data'] = $this->StoreModel->getAmazonRecords(array('id'=>$amazon_id));
         $affiliate_tag = $amazon['data'][0]['affiliate_tag'];
         $amazon_region_id = $amazon['data'][0]['region_id'];

         $amazon_region['data'] = $this->StoreModel->getAmazonRegion(array('id'=>$amazon_region_id));
         $amazonRegionId = $amazon_region['data'][0]['region_code'];

         $categoryRecords['data'] = $this->StoreModel->getCategoryRecords(array('record_id'=>$id));
         $amazonCategory = $categoryRecords['data'][0]['category'];

          $record_id = $data['record'][0]['id'];
          $user_id = $data['record'][0]['user_id'];

          $categoryRecords['data'] = $this->StoreModel->getCategoryRecords(array('record_id'=>$id));
          $tracking_link_data = $this->StoreModel->getData('impact',array('user_id' => $user_id));
//          $tracking_link = $tracking_link_data[0]['link'];

          $video_category = $categoryRecords['data'][0]['video_category'];
          $site_category_id  = $categoryRecords['data'][0]['id'];
          
          $custompickCategory = $categoryRecords['data'][0]['data'];
          
          $wordpress_id = $data['record'][0]['wordpress_id'];
          $wordpressRecords['data'] = $this->StoreModel->getWordpressRecords(array('id'=>$wordpress_id));
          $WordpressLogo = $wordpressRecords['data'][0]['logo_url'];
          $WordpressLogoDescription = $wordpressRecords['data'][0]['description'];

          // Get User Access Token
          $envato_post =  $this->StoreModel->getData('envato',array('user_id' => $user_id));
          $token = $envato_post[0]['access_token'];
          $ref_token = $envato_post[0]['refresh_token'];


          // Check user Access Token Expire Time
         $last_date = strtotime($envato_post[0]['modified']);
         $curr_date = strtotime(date("Y-m-d h:i:s"));

         $hours = $curr_date - $last_date;

         // Need to Update user access token
         if($hours >= 3600 || $hours <= 0){

             $refresh_token_res = $this->envato->refresh_access_token('https://api.envato.com/token',$ref_token);

             if(empty($refresh_token_res->error)){
                 $data_envato['access_token'] = $refresh_token_res->access_token;
                 $data_envato['modified'] =  date("Y-m-d h:i:s");

                 $this->Membershipmodel->updateData('envato',$user_id,$data_envato);
                 $token = $refresh_token_res->access_token;
             }
         }


          //case 1
          //check if video_category  is 1 autopick
         $stylesheet =  '<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">';

          if($video_category == 1) {

              $no_of_products = $categoryRecords['data'][0]['no_of_products'];
              $sitekeyword = $categoryRecords['data'][0]['keyword'];


               //google custom search
               $keywordSearch = urlencode($sitekeyword);
               $newkeyword = str_replace('+', '%20', $keywordSearch);


               if(empty($no_of_products)){
                
                     $no_of_products = 0;
                }
                
               else
               
                {
                     $no_of_products = $no_of_products;
                }


              // Fetch Envato Products against keyword and get limited product against no_of_products
              try {

                  $url = 'https://api.envato.com/v1/discovery/search/search/item?page_size='.$no_of_products.'&term='.$newkeyword.'&site=codecanyon.net';

                  $envato_data = $this->envato->fetch_products($url,$token); // Fetch Envato Products

                  // Update Fetch Records in Categories Table
                  $this->StoreModel->updateData($site_category_id, 'categories', array('data' => $envato_data));

                  $envato_decode_data = json_decode($envato_data);

                  if(empty($envato_decode_data->error)){

                      try{
                          foreach ($envato_decode_data->matches as $value){
                              $name = $value->name;
                              $price = $value->price_cents/100;
                              $preview_image = $value->previews->landscape_preview->landscape_url;
                              $time = strtotime($value->updated_at);
                              $updated_at = date("d M, Y", $time);
                              $rating = $this->envato->toStars($value->rating->rating);
                              $name .= $stylesheet.'<br>'.$rating.'<br>'.'<h4>Price : <strong style="color:#ff7f2e">$'.$price.
                                  '</strong></h4>';
                              $name = addslashes($name);
                              $button_url = $value->url;
                              if(!empty($tracking_link)){
                                  $button_url = $tracking_link.'?u='.$button_url;
                              }

                              $content1 = $stylesheet.'<img class="alignnone size-medium wp-image-13"
                                    src="'.$preview_image. '"
                                    alt="image" />
                                    <h4>Price : <strong style="color:#ff7f2e">$'.$price.
                                  '</strong></h4>
                                    <br><h4>Sales : '.$value->number_of_sales.'</h4>
                                     <br><h4>Rating: '.$rating.'</h4>
                                     <br><h4>Last Updated: '.$updated_at.'</h4>'.
                                  '<a href="javascript:void(0)" onclick="window.open('."'".$button_url."','_blank'".')" target="_blank">'.'<img src="'.site_url().'assets/img/buttons/'.$buttons_data.'">'.'</a>'.
                                  '</br></br>'.$value->description_html.
                                  '</br></br><a href="javascript:void(0)" onclick="window.open('."'".$button_url."','_blank'".')" target="_blank">'.'<img src="'.site_url().'assets/img/buttons/'.$buttons_data.'">'.'</a>';


                              $content = '<script type="text/javascript" language="javascript">
                              var aax_size="728x90";
                              var aax_pubname = "'.$affiliate_tag .'"
                              var aax_src="302";
                              </script>
                              <script type="text/javascript" language="javascript" src="http://c.amazon-adsystem.com/aax2/assoc.js"></script>
	                          '.$content1.'
	                          <script type="text/javascript" language="javascript">
                              var aax_size="160x600";
                              var aax_pubname = " '.$affiliate_tag.'"
                              var aax_src="302";
                              </script>
                              <script type="text/javascript" language="javascript" src="http://c.amazon-adsystem.com/aax2/assoc.js"></script>
	                         <script type="text/javascript">
	                         amzn_assoc_ad_type ="responsive_search_widget"; 
	                         amzn_assoc_tracking_id ="'.$affiliate_tag.'"
	                         amzn_assoc_marketplace ="amazon"; 
	                         amzn_assoc_region ="'.$amazonRegionId.'"; 
	                         amzn_assoc_placement =""; 
	                         amzn_assoc_search_type = "search_widget";
	                         amzn_assoc_width ="auto"; 
	                         amzn_assoc_height ="auto";  
	                         amzn_assoc_default_search_category ="'.$amazonCategory.'"
	                         amzn_assoc_default_search_key ="";
	                         amzn_assoc_theme ="light"; 
	                         amzn_assoc_bg_color ="FFFFFF"; </script>
                             <script src="http://z-in.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&Operation=GetScript&ID=OneJS&WS=1&Marketplace=IN"></script>';

                              $content = addslashes($content);

                              $description = addslashes($this->limit_text($value->description, 35));
                              $wp->createPost($status='publish', $comment_status='open', $ping_status='open', $cpanel_data,$content, $preview_image,$installation_path,$name,$preview_image,$WordpressLogo,$WordpressLogoDescription,$description);
                              sleep(1);
                          }
                      }
                      catch(Exception $e){
                          $this->StoreModel->markFailed('records', $record_id, $e->getMessage());
                      }

                  }else{
                      $this->StoreModel->markFailed('records', $record_id, $envato_decode_data->error);
                  }


              }catch (Exception $e) {

                  $this->StoreModel->markFailed('records', $record_id, $e->getMessage());

              }
              // End Custom Code Sumit


              
              
              
              
        }//end of if
    else {

        // If User Select Custom Videos
        // case 2 video category is 2
        $category_data = $this->StoreModel->getData('categories',array('record_id' => $record_id));
        $site_data = $this->StoreModel->getData('single_site_temp',array('record_id'=> $record_id));

        if($category_data){

            $product = $category_data[0]['data'];
            $product = str_replace(array('[',']','"'),'',$product);
            $product_arr = explode(',',$product);

            // Fetch Single Site Data and Filter Against Products Id
            $site_data_decode = json_decode($site_data[0]['data']);

            try {
                foreach ($site_data_decode->matches as $value) {
                    if (in_array($value->id, $product_arr)) {
                        $name = $value->name;
                        $price = $value->price_cents/100;
                        $preview_image = $value->previews->landscape_preview->landscape_url;
                        $time = strtotime($value->rating->updated->at);
                        $updated_at = date("d M, Y", $time);
                        $rating = $this->envato->toStars($value->rating->rating);
                        $name .= $stylesheet.'<br>'.$rating.'<br>'.'<h4>Price : <strong style="color:#ff7f2e">$'.$price.
                            '</strong></h4>';
                        $name = addslashes($name);
                        $button_url = $value->url;
                        if(!empty($tracking_link)){
                            $button_url = $tracking_link.'?u='.$button_url;
                        }

                        $content1 = $stylesheet.'<img class="alignnone size-medium wp-image-13"
                                    src="'.$preview_image. '"
                                    alt="image" />
                                    <h4>Price : <strong style="color:#ff7f2e">$'.$price.
                            '</strong></h4>
                                    <br><h4>Sales : '.$value->number_of_sales.'</h4>
                                     <br><h4>Rating: '.$rating.'</h4>
                                     <br><h4>Last Updated: '.$updated_at.'</h4>'.
                            '<a href="javascript:void(0)" onclick="window.open('."'".$button_url."','_blank'".')" target="_blank">'.'<img src="'.site_url().'assets/img/buttons/'.$buttons_data.'">'.'</a>'.
                            '</br></br>'.$value->description_html.
                            '</br></br><a href="javascript:void(0)" onclick="window.open('."'".$button_url."','_blank'".')" target="_blank">'.'<img src="'.site_url().'assets/img/buttons/'.$buttons_data.'">'.'</a>';

                        $content = '<script type="text/javascript" language="javascript">
                              var aax_size="728x90";
                              var aax_pubname = "'.$affiliate_tag .'"
                              var aax_src="302";
                              </script>
                              <script type="text/javascript" language="javascript" src="http://c.amazon-adsystem.com/aax2/assoc.js"></script>
	                          '.$content1.'
	                          <script type="text/javascript" language="javascript">
                              var aax_size="160x600";
                              var aax_pubname = " '.$affiliate_tag.'"
                              var aax_src="302";
                              </script>
                              <script type="text/javascript" language="javascript" src="http://c.amazon-adsystem.com/aax2/assoc.js"></script>
	                         <script type="text/javascript">
	                         amzn_assoc_ad_type ="responsive_search_widget"; 
	                         amzn_assoc_tracking_id ="'.$affiliate_tag.'"
	                         amzn_assoc_marketplace ="amazon"; 
	                         amzn_assoc_region ="'.$amazonRegionId.'"; 
	                         amzn_assoc_placement =""; 
	                         amzn_assoc_search_type = "search_widget";
	                         amzn_assoc_width ="auto"; 
	                         amzn_assoc_height ="auto";  
	                         amzn_assoc_default_search_category ="'.$amazonCategory.'"
	                         amzn_assoc_default_search_key ="";
	                         amzn_assoc_theme ="light"; 
	                         amzn_assoc_bg_color ="FFFFFF"; </script>
                             <script src="//z-in.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&Operation=GetScript&ID=OneJS&WS=1&Marketplace=IN"></script>';


                        $content = addslashes($content);
                        $description = addslashes($this->limit_text($value->description, 35));

                        $wp->createPost($status='publish', $comment_status='open', $ping_status='open', $cpanel_data,$content, $preview_image,$installation_path,$name,$preview_image,$WordpressLogo,$WordpressLogoDescription,$description);
                        sleep(1);
                    }
                }
            }catch(Exception $e){
                $this->StoreModel->markFailed('records', $record_id, $e->getMessage());
            }
        }else{
            $this->StoreModel->markFailed('records', $record_id, 'empty category');
        }


            
        }//end of else
          

    }




    /**
     * Function: curl_file_get_contents
     *
     * This function will get a valid url and return json data
     *
     * @param : url
     *
     * @return : json
     */
    public function curl_file_get_contents($url){ 
        
       $curl = curl_init();
       $userAgent = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)';
       curl_setopt($curl,CURLOPT_URL,$url);
       curl_setopt($curl,CURLOPT_RETURNTRANSFER,TRUE);
       curl_setopt($curl,CURLOPT_CONNECTTIMEOUT,5);   
       curl_setopt($curl, CURLOPT_USERAGENT, $userAgent); 
       curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);  
       curl_setopt($curl, CURLOPT_AUTOREFERER, TRUE); 
       curl_setopt($curl, CURLOPT_TIMEOUT, 1500); 
       curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE); 
       $contents = curl_exec($curl);
       curl_close($curl);
       return $contents;
    }


    function limit_text($text, $limit) {
        if (str_word_count($text, 0) > $limit) {
            $words = str_word_count($text, 2);
            $pos = array_keys($words);
            $text = substr($text, 0, $pos[$limit]).' ...' ;
        }
        return $text;
    }

}