<?php

defined('BASEPATH') OR exit('No direct script access allowed');
use TBETool\PasswordGenerator;
include("library/wordpress/WordpressManager.php");

class CreateMultiSitePostCronController extends CI_Controller
{
    function __construct()
    {
        parent:: __construct();
        //$this->multiSitePost();

        $this->load->model('MultipleStoreModel');
        $this->load->model('StoreModel');

        $this->load->library('Envato');
    }



    /**
     * Function: multiSitePost
     *
     * This function fetches multi site record details having statuses as processing_data
     *
     * @param : null
     *
     * @return : null
     */
    public function multiSitePost()
    {

        $status = $this->MultipleStoreModel->getData('statuses',array('slug'=>'processing_data'));
        $status_id = $status[0]['id'];

        $records = $this->MultipleStoreModel->getData('multiple_store_records',array('statuses_id' => $status_id));

        if (empty($records)) {
            echo 'Records empty';
            die();
        }

        foreach ($records as $record)
        {
            try {
                $this->processPost($record);
                $this->MultipleStoreModel->updateData($record['id'],'multiple_store_records',array('statuses_id'=>3));
            } catch (Exception $exception) {
                $this->MultipleStoreModel->updateData($record['id'],'multiple_store_records',array('status'=>1));
                echo $exception->getMessage();
            }
        }
    }



    /**
     * Function: processPost
     *
     * This function will fetches all single site records having statuses as processing_data
     * get all current site records and connect wordpress account or call a post function to post
     *
     * @param : record
     *
     * @return : null
     */
    private function processPost($record)
    {

        $id = $record['id'];
        $cpanel_id = $record['cpanel_id'];
        $amazon_id = $record['amazon_id'];
        $cpanel_data = $this->MultipleStoreModel->getData('cpanel',array('id'=> $cpanel_id));
        $amazon_data = $this->MultipleStoreModel->getData('amazon',array('id'=>$amazon_id));

        // Cpanel Details
        $cpanel_username = $cpanel_data[0]['username'];
        $cpanel_password = $cpanel_data[0]['password'];
        $cpanel_domain = $cpanel_data[0]['domain'];


        // fetch multiple stores associate to 'multiple_store_records_id'
        $stores = $this->MultipleStoreModel->getData('multiple_stores',array('multiple_store_records_id'=>$id));

        foreach ($stores as $store)
        {

            $wordpress_data = $store;
            $multi_store   = $this->MultipleStoreModel->getData('multiple_store_categories',array('multiple_stores_id'=>$store['id']));
            $installation_path = $store['installation_path'];
            $buttons_data   = $this->StoreModel->getField('name','buttons',$store['button_id']);
            $wordpress_logo = $wordpress_data['logo_url'];
            $wordpress_desc = $wordpress_data['description'];


            try {
                $wp = new WordpressManager($wordpress_data['db_username'],
                    $wordpress_data['db_password'],
                    $wordpress_data['db_name']
                );

                $wp->setupCpanel($cpanel_username, $cpanel_password, $cpanel_domain);

                if($this->MultipleStoreModel->updateData($multi_store[0]['id'],'multiple_store_categories',array('status'=>2))){

                    try{
                        $post = $this->Post($wp, $cpanel_data,$buttons_data,$store['id'],$amazon_data,$installation_path,$wordpress_logo,$wordpress_desc);

                        if($post)
                        {
                            $date = Date('Y-m-d H:i:s');
                            $this->MultipleStoreModel->updateData($store['id'],'multiple_store_categories',array('status'=>3,'modified'=>$date));
                            $this->MultipleStoreModel->updateData($store['id'],'multiple_stores',array('status'=>1));
                        }
                    }catch(Exception $e){
                        echo $e->getMessage();
                        $this->MultipleStoreModel->updateData($store['id'],'multiple_stores',array('message'=>$e->getMessage(),'status'=>1));
                    }
                }

            } catch(Exception $e) {
                echo $e->getMessage();
                $this->MultipleStoreModel->updateData($store['id'],'multiple_stores',array('message'=>$e->getMessage(),'status'=>1));
            }
        }

    }



    /**
     * Function: curl_file_get_contents
     *
     * This function will get a valid url and return json data
     *
     * @param : url
     *
     * @return : json
     */
    public function curl_file_get_contents($url){

        $curl = curl_init();
        $userAgent = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)';
        curl_setopt($curl,CURLOPT_URL,$url);
        curl_setopt($curl,CURLOPT_RETURNTRANSFER,TRUE);
        curl_setopt($curl,CURLOPT_CONNECTTIMEOUT,5);
        curl_setopt($curl, CURLOPT_USERAGENT, $userAgent);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);
        curl_setopt($curl, CURLOPT_AUTOREFERER, TRUE);
        curl_setopt($curl, CURLOPT_TIMEOUT, 1500);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        $contents = curl_exec($curl);
        curl_close($curl);
        return $contents;
    }



    /**
     * Function: Post
     *
     * This function will take five arrguments to create post wordpress connection object, cpanel details,
     * user selected buttons data, current records table id, theme installation path, logo url, logo description
     * before creating post it also check video type is custom or auto
     * if auto- function fetch random products against keywords and post on wordpress blog
     *
     * @param : wp,cpanel_data,button_data,$store_id,installation_path,$wordpress_logo,$wordpress_desc
     *
     * @return : null
     */
    private function Post($wp, $cpanel_data,$buttons_data,$store_id,$amazon_data,$installation_path,$wordpress_logo,$wordpress_desc){

        $data['record'] = $this->StoreModel->getmultiSiteRecords(array('id'=>$store_id));
        $amazon_id = $data['record'][0]['amazon_id'];
        $amazon['data'] = $this->StoreModel->getAmazonRecords(array('id'=>$amazon_id));
        $affiliate_tag = $amazon['data'][0]['affiliate_tag'];
        $amazon_region_id = $amazon['data'][0]['region_id'];

        $amazon_region['data'] = $this->StoreModel->getAmazonRegion(array('id'=>$amazon_region_id));
        $amazonRegionId = $amazon_region['data'][0]['region_code'];

        $categoryRecords['data'] = $this->StoreModel->getmultiCategorySiteRecords(array('multiple_stores_id'=>$store_id));
        $amazonCategory = $categoryRecords['data'][0]['category'];

        $no_of_products = $categoryRecords['data'][0]['no_of_products'];
        $sitekeyword = $categoryRecords['data'][0]['keyword'];
        $multi_id = $categoryRecords['data'][0]['id'];
        $user_id = $categoryRecords['data'][0]['user_id'];


        //google custom search

        $keywordSearch = urlencode($sitekeyword);
        $newkeyword = str_replace('+', '%20', $keywordSearch);


        if(empty($no_of_products)){

            $no_of_products = 0;
        }

        else

        {
            $no_of_products = $no_of_products;
        }

        // Get User Access Token
        $envato_post =  $this->StoreModel->getData('envato',array('user_id' => $user_id));
        $token = $envato_post[0]['access_token'];
        $ref_token = $envato_post[0]['refresh_token'];
        $tracking_link_data = $this->StoreModel->getData('impact',array('user_id' => $user_id));
        $tracking_link = $tracking_link_data[0]['link'];


        // Check user Access Token Expire Time
        $last_date = strtotime($envato_post[0]['modified']);
        $curr_date = strtotime(date("Y-m-d h:i:s"));

        $hours = $curr_date - $last_date;

        // Need to Update user access token
        if($hours >= 3600 || $hours <= 0){

            $refresh_token_res = $this->envato->refresh_access_token('https://api.envato.com/token',$ref_token);

            if(empty($refresh_token_res->error)){
                $data_envato['access_token'] = $refresh_token_res->access_token;
                $data_envato['modified'] =  date("Y-m-d h:i:s");

                $this->Membershipmodel->updateData('envato',$user_id,$data_envato);
                $token = $refresh_token_res->access_token;
            }
        }

        try {

            $url = 'https://api.envato.com/v1/discovery/search/search/item?page_size='.$no_of_products.'&term='.$newkeyword.'&site=codecanyon.net';

            $envato_data = $this->envato->fetch_products($url,$token); // Fetch Envato Products


            // Update Fetch Records in Categories Table
            $this->StoreModel->updateData($multi_id, 'multiple_store_categories', array('data' => $envato_data));

            $envato_decode_data = json_decode($envato_data);

            if(empty($envato_decode_data->error)){

                try{
                    $stylesheet =  '<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">';

                    foreach ($envato_decode_data->matches as $value){
                        $name = $value->name;
                        $price = $value->price_cents/100;
                        $preview_image = $value->previews->landscape_preview->landscape_url;
                        $time = strtotime($value->updated_at);
                        $updated_at = date("d M, Y", $time);
                        $rating = $this->envato->toStars($value->rating->rating);
                        $name .= $stylesheet.'<br>'.$rating.'<br>'.'<h4>Price : <strong style="color:#ff7f2e">$'.$price.
                            '</strong></h4>';
                        $name = addslashes($name);
                        $button_url = $value->url;
                        if(!empty($tracking_link)){
                            $button_url = $tracking_link.'?u='.$button_url;
                        }

                        $content1 = $stylesheet.'<img class="alignnone size-medium wp-image-13"
                                    src="'.$preview_image. '"
                                    alt="image" />
                                    <h4>Price : <strong style="color:#ff7f2e">$'.$price.
                            '</strong></h4>
                                    <br><h4>Sales : '.$value->number_of_sales.'</h4>
                                     <br><h4>Rating: '.$rating.'</h4>
                                     <br><h4>Last Updated: '.$updated_at.'</h4>'.
                            '<a href="javascript:void(0)" onclick="window.open('."'".$button_url."','_blank'".')" target="_blank">'.'<img src="'.site_url().'assets/img/buttons/'.$buttons_data.'">'.'</a>'.
                            '</br></br>'.$value->description_html.
                            '</br></br><a href="javascript:void(0)" onclick="window.open('."'".$button_url."','_blank'".')" target="_blank">'.'<img src="'.site_url().'assets/img/buttons/'.$buttons_data.'">'.'</a>';

                        $content = '<script type="text/javascript" language="javascript">
                              var aax_size="728x90";
                              var aax_pubname = "'.$affiliate_tag .'"
                              var aax_src="302";
                              </script>
                              <script type="text/javascript" language="javascript" src="http://c.amazon-adsystem.com/aax2/assoc.js"></script>
	                          '.$content1.'
	                          <script type="text/javascript" language="javascript">
                              var aax_size="160x600";
                              var aax_pubname = " '.$affiliate_tag.'"
                              var aax_src="302";
                              </script>
                              <script type="text/javascript" language="javascript" src="http://c.amazon-adsystem.com/aax2/assoc.js"></script>
	                         <script type="text/javascript">
	                         amzn_assoc_ad_type ="responsive_search_widget"; 
	                         amzn_assoc_tracking_id ="'.$affiliate_tag.'"
	                         amzn_assoc_marketplace ="amazon"; 
	                         amzn_assoc_region ="'.$amazonRegionId.'"; 
	                         amzn_assoc_placement =""; 
	                         amzn_assoc_search_type = "search_widget";
	                         amzn_assoc_width ="auto"; 
	                         amzn_assoc_height ="auto";  
	                         amzn_assoc_default_search_category ="'.$amazonCategory.'"
	                         amzn_assoc_default_search_key ="";
	                         amzn_assoc_theme ="light"; 
	                         amzn_assoc_bg_color ="FFFFFF"; </script>
                             <script src="//z-in.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&Operation=GetScript&ID=OneJS&WS=1&Marketplace=IN"></script>';


                        $content = addslashes($content);
                        $description = addslashes($this->limit_text($value->description, 35));
                        $wp->createPost($status='publish', $comment_status='open', $ping_status='open', $cpanel_data,$content, $preview_image,$installation_path,$name,$preview_image,$wordpress_logo,$wordpress_desc,$description);
                        sleep(1);
                    }
                }
                catch(Exception $e){
                    $this->MultipleStoreModel->updateData($store_id,'multiple_stores',array('message'=>$e->getMessage(),'status'=>1));
                }

            }else{
                $this->MultipleStoreModel->updateData($store_id,'multiple_stores',array('message'=>$envato_decode_data->error,'status'=>1));
            }

        } catch (Exception $e) {

            $this->MultipleStoreModel->updateData($store_id,'multiple_stores',array('message'=>$e->getMessage(),'status'=>1));
        }

    }


    function limit_text($text, $limit) {
        if (str_word_count($text, 0) > $limit) {
            $words = str_word_count($text, 2);
            $pos = array_keys($words);
            $text = substr($text, 0, $pos[$limit]).' ...' ;
        }
        return $text;
    }

}