<?php
defined('BASEPATH') OR exit('No direct script access allowed');
include("library/cpanelupi/CpanelManager.php");

class CreateMultiSiteCronController extends CI_Controller {

    function __construct()
    {
        parent:: __construct();
        //$this->multipleSiteCreate();
        $this->load->model('MultipleStoreModel');
        $this->load->model('StoreModel');

        $this->load->library('Envato');
    }

    
    /**
     * Function: multipleSiteCreate
     *
     * This function fetches multi site record details having statuses as ready_create_store
     *
     * @param : null
     *
     * @return : null
     */
    public function multipleSiteCreate() {

        $status = $this->MultipleStoreModel->getData('statuses',array('slug'=>'ready_create_store'));
        
        $status_id = $status[0]['id'];
        
        $records = $this->MultipleStoreModel->getData('multiple_store_records',array('statuses_id' => $status_id));

        if (empty($records)) {
            echo 'Records empty';
            die();
        }
    
        foreach ($records as $record) {
            
            // mark record as processing
            $data = $this->_processData($record);  
            $this->MultipleStoreModel->updateData($record['id'],'multiple_store_records',array('statuses_id'=>2));
            
        }

        print_r(array('status'=>1));

    }




    /**
     * Function: _processData
     *
     * This function will fetch Single Site records having statuses as ready_create_store and all it's
     * related data like:- wordpress_data,theme_data,cpanel_data etc.
     * connect cpanel account, process wordpress database then process wordpress theme
     * and execute cell command for create blog post
     *
     * @param : record
     *
     * @return : null
     */
    public function _processData($record){
        echo "process";
        $id = $record['id'];   
        $cpanel_id = $record['cpanel_id'];  
        $user_id = $record['user_id'];      
        $cpanel_data = $this->MultipleStoreModel->getData('cpanel',array('id' => $cpanel_id));  
        $cpanel_username = $cpanel_data[0]['username'];    
        $cpanel_password = $cpanel_data[0]['password'];       
        $cpanel_domain = $cpanel_data[0]['domain'];       

        
        //fetch all subsites created
        $stores = $this->MultipleStoreModel->getData('multiple_stores',array('multiple_store_records_id'=>$id));
        
       
        foreach ($stores as $store)
        {
            $user_data = $this->MultipleStoreModel->getData('users',array('id'=>$user_id));
            $wordpress_data[0] = $store;
            $theme_data = $this->MultipleStoreModel->getData('themes',array('id'=>$store['theme_id']));  
            $cpanel_installation_path = $store['installation_path'];   


            try {
                
                $cpanel = new CpanelManager($cpanel_username,$cpanel_password,$cpanel_domain);  
              
                $wordpress_data = $cpanel->processDatabase($user_data, $wordpress_data, $cpanel_data, $theme_data,$cpanel_installation_path);
                
                $response_wordpress = array(
                    'db_username'=>$wordpress_data[0]['db_username'],
                    'db_name'=>$wordpress_data[0]['db_name']
                );  
                
                

                $this->MultipleStoreModel->updateData($store['id'],'multiple_stores',$response_wordpress);

                // process wordpress file
                $cpanel->processWordpress($wordpress_data, $cpanel_installation_path);

                // process theme file
                $cpanel->processTheme($theme_data,$cpanel_installation_path);

                if($theme_data[0]['recommend'] == 1)
                {
                    $explode = explode('.',$theme_data[0]['file']);
                    $theme_name = $explode[0];
                    $cpanel->themeFile($wordpress_data[0], $cpanel_installation_path,$theme_name);

                }
                
                $command = "php ".FCPATH."index.php CreateMultiSitePostCronController multiSitePost > /dev/null &";
                exec($command);

            } catch(Exception $e) {

                $this->MultipleStoreModel->updateData($store['id'],'multiple_stores',array('message'=>$e->getMessage(),'status'=>1));
                echo $e->getMessage();
            }
        }

     }

}