<?php
defined('BASEPATH') OR exit('No direct script access allowed');

//include cPanel UAPI
include("library/cpanelupi/CpanelManager.php");

class CpanelController extends CI_Controller{
    public function __construct(){
    
         parent:: __construct();
     }

    
    /**
     * Function: index
     *
     * This function loads the index page for the cPanel, where user can see
     * the listing of cPanel account associated to him/her, also can create new
     * cPanel record.
     *
     * @param : null
     *
     * @return : null
     */
    public function index()
    {
        if($this->session->userdata('account_type') == 'team'){
           
             $user_id = $this->session->userdata('user_id');  

         }else{
             
            $user_id  = $this->session->userdata('user_id');
    }

        if($this->input->post('submit'))
        {
            $domain = trim($this->input->post('domain'),' ');
            $cpanel = array(
                            'domain' => $domain,
                            'username' => $this->input->post('cpanel_username'),
                            'password' => $this->input->post('cpanel_password'),
                            'user_id' => $user_id,
                            'status' => 1
                       );

            if($this->Membershipmodel->exists('cpanel',array('domain'=>$cpanel['domain'],'user_id'=>$cpanel['user_id'])))
            {
                $this->session->set_flashdata('error','Requested Domain already exist');
                redirect('cpanel-view');
            }

            try{

                $response_data = $this->cpanelChecker($cpanel['username'], $cpanel['password'], $domain);
                 
                $cpanel_response = array("response_documentroot" => $response_data['response_documentroot'] ,"response_homedir" =>$response_data['response_homedir']);
               
               if(!empty($response_data)){

                  $this->Membershipmodel->save('cpanel', array_merge($cpanel,$cpanel_response));
                  $this->session->set_flashdata('success','Successfully connected to your cPanel account');
                  redirect('cpanel-view');
              }
              else{

                  $this->session->set_flashdata('success','Something went wrong. Not connected to your cPanel account. Try again !');
                  redirect('cpanel-view');
              }

            } catch (Exception $exception) {

                $this->session->set_flashdata('error',$exception->getMessage());
                redirect('cpanel-view');
            }
         }

        $data['cpanel_records'] = $this->Membershipmodel->getData('cpanel',array('user_id'=>$user_id));
        $this->load->view('cpanel/index',$data);
    }

    



    /**
     * Function: cpanelChecker
     *
     * This function will check for whether cPanel credentials are valid or not.
     * If credentials are valid, return true otherwise will throw exception stating
     * error message
     *
     * @param : username,password,host
     *
     * @return : string
    */
    public function cpanelChecker($username, $password, $host){

        try {
              $cpanel = new CpanelManager($username, $password, $host);
              return $cpanel->info();
        } catch(Exception $e) {

              throw new Exception($e->getMessage());
        }
     }

    


    /**
     * Function: delete
     *
     * This function delete the cpanel records form 'cpanel' table
     *
     * @param : null
     *
     * @return : null
     */
    public function delete(){
      
        if($this->Membershipmodel->delete('cpanel',array('id'=>$this->input->get('id'))))
        {
            $this->session->set_flashdata('success','Record deleted successfully');
            redirect('cpanel-view');
        }
     }
}