<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use ApaiIO\ApaiIO;
use ApaiIO\Configuration\GenericConfiguration;
use ApaiIO\Operations\Search;
use ApaiIO\Request\GuzzleRequest;
use GuzzleHttp\Client;

class AmazonController extends CI_Controller{
    
    public function __construct(){

        parent:: __construct();
    }


    /* This function loads the index page for the Amazon, where user can see
       the listing of Amazon account associated to him/her, also can create new
       amazon record.
     */
    public function index(){
        
        if($this->session->userdata('account_type') == 'team'){
           
             $user_id = $this->session->userdata('user_id');  
        }
       else
          {
             
             $user_id  = $this->session->userdata('user_id');
          }
         
       if($this->input->post('submit'))
          {
            
            $amazon = array(

                        'region_id' => $this->input->post('amazon_region'),
                        'affiliate_tag' => $this->input->post('affiliate_tag'),
                        'user_id' => $user_id,
                        'status' => 1
                      );

            if($this->Membershipmodel->exists('amazon',array('affiliate_tag'=>$amazon['affiliate_tag'],'user_id'=>$amazon['user_id'])))
            {
                $this->session->set_flashdata('error','Affiliate already exist');
                redirect('amazon');
            }
            $amazon_region = $this->Membershipmodel->getField('region_code','amazon_region',$amazon['region_id']);
            $this->Membershipmodel->save('amazon', $amazon);
            $this->session->set_flashdata('success','Successfully connected to your Amazon account for the requested affiliate');
            
            redirect('amazon');
        }

        $data['regions'] = $this->Membershipmodel->getTable('amazon_region');
        $data['amazon_records'] = $this->Membershipmodel->getData('amazon',array('user_id'=>$user_id));
        $this->load->view('amazon/index',$data);
     }


    

     /* This function will delete requested affiliate */ 
     public function delete(){
      
        if($this->Membershipmodel->delete('amazon',array('id'=>$this->input->get('id'))))
        {
            $this->session->set_flashdata('success','Affiliate deleted Successfully');
            redirect('amazon');
        }
     }
}