<?php
/**
 * The template for displaying Author's section.
 *
 * @package Zomer
 */

?>

<?php if ( '' != ( $author_bio = get_the_author_meta( 'description' ) ) ) : ?>
<div class="entry-author">
	<div class="author-avatar">
		<?php
		/**
		 * Filter the author bio avatar size.
		 *
		 * @param int $size The avatar height and width size in pixels.
		 */
		$author_bio_avatar_size = apply_filters( 'zomer_author_bio_avatar_size', 352 );
        
        // Author's name.
        $author_name = '<span class="author-name">' . esc_html( get_the_author() ) . '</span>';

		echo get_avatar( get_the_author_meta( 'user_email' ), $author_bio_avatar_size );
		?>
	</div><!-- .author-avatar -->

	<div class="author-heading">
		<h2 class="author-title"><?php printf( esc_html__( 'Published by %s', 'zomer' ), $author_name ); // WPCS: XSS OK. ?></h2>
	</div><!-- .author-heading -->

	<p class="author-bio">
		<?php echo wp_kses_post( $author_bio ); ?>
		<a class="author-link" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
			<?php printf( esc_html__( 'View all posts by %s', 'zomer' ), $author_name ); // WPCS: XSS OK. ?>
		</a>
	</p><!-- .author-bio -->
</div><!-- .entry-auhtor -->

<?php 
endif; 
