<?php
/**
 * Template part for comments link.
 *
 * @package Zomer
 */

// Current post title.
$post_title = get_the_title();
            
// Zero comments.
$zero_screen_reader_text = ' <span class="screen-reader-text"> ' . esc_html__( 'comments on %s', 'zomer' ) . '</span>';
$zero = '0' . sprintf( $zero_screen_reader_text, $post_title ); // WPCS: XSS OK.

// One comment.
$one_screen_reader_text = ' <span class="screen-reader-text"> ' . esc_html__( 'comment on %s', 'zomer' ) . '</span>';
$one = '1' . sprintf( $one_screen_reader_text, $post_title ); // WPCS: XSS OK.

// Many comments.
$more_screen_reader_text = ' <span class="screen-reader-text"> ' . esc_html__( 'comments on %s', 'zomer' ) . '</span>';
$more = '%' . sprintf( $more_screen_reader_text, $post_title ); // WPCS: XSS OK.

comments_popup_link( $zero, $one, $more );
