<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Zomer
 */

get_header(); ?>

<div class="container">

	<?php while ( have_posts() ) : the_post(); ?>

		<?php get_template_part( 'template-parts/single/post', 'header' ); ?>

	<div id="primary" class="content-area row">
		<main id="main" class="site-main <?php echo esc_attr( zomer_get_blog_primary_class() ); ?>" role="main">

		<?php

			get_template_part( 'template-parts/content', 'single' );

			the_post_navigation( array(
				'next_text' => '<span class="meta-title has-icon">' . esc_html__( 'Next', 'zomer' ) . '</span> ' .
					'<span class="post-title secondary-font">%title</span>',
				'prev_text' => '<span class="meta-title has-icon">' . esc_html__( 'Previous', 'zomer' ) . '</span> ' .
					'<span class="post-title secondary-font">%title</span>',
			) );

			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;
		?>

	<?php endwhile; ?>

		</main><!-- #main -->

		<?php get_sidebar(); ?>

	</div><!-- #primary -->
</div><!-- .container -->
<?php
get_footer();
