jQuery( document ).ready( function() {

    if( jQuery( 'html' ).attr( 'dir' ) == 'rtl' ) {
        var htmlRTL = true;
    } else {
        var htmlRTL = false;
    }

    var pageContainer = jQuery( document.getElementById( 'page' ) );
    var headerContainer = pageContainer.find( document.getElementById( 'masthead' ) );
    var contentContainer = pageContainer.find( document.getElementById( 'content' ) );

    // Add custom class to table element and make it responsive
    jQuery( function() {
        jQuery( 'table' ).addClass( 'table' );
        jQuery( 'table' ).wrap( '<div class="table-responsive" />' );

        var infiniteCount = 0;

        jQuery( document.body ).on( 'post-load', function() {

            infiniteCount = infiniteCount + 1;

            var infiniteItems = jQuery( '.infinite-wrap.infinite-view-' + infiniteCount );
            infiniteItems.find( 'table' ).addClass( 'table' ).wrap( '<div class="table-responsive" />' );

        });
    });

    //Add custom mobile class
    jQuery( function() {
        if( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
            jQuery( 'body' ).addClass( 'mobile-view' );
        }
    } );

    // Header search section.
    jQuery( function() {
        var searchButton = headerContainer.find( document.getElementById( 'header-search' ) );
        var searchForm = headerContainer.find( '.search-form' );
        var currentSearchText = searchButton.text();

        searchButton.on( 'click', function(e) {
            e.preventDefault();

            searchForm.toggle( 'fast', function() {
                if ( jQuery( this ).is( ':visible' ) ) {
                    searchForm.find( '.search-field' ).focus();
                    searchButton.text( searchButton.data( 'close-text' ) ).addClass( 'active' );
                } else {
                    searchButton.text( currentSearchText ).removeClass( 'active' );
                }
            });

        });
    });

    // Mobile Menu.
    jQuery( function() {
        var mobileMenuContainer = jQuery( document.getElementById( 'mobile-navigation' ) );
        headerContainer.find( '.search-form, .menu' ).clone().appendTo( '#mobile-navigation' );
        headerContainer.find( '.social-list' ).clone().appendTo( '#mobile-navigation' );

        var bigSlideAPI = jQuery( document.getElementById( 'mobile-menu-button' ) ).bigSlide({
            menu: ( '#toggle-sidebar' ),
            side: htmlRTL ? 'left' : 'right',
            menuWidth: '340px',
            afterOpen: function() {
                jQuery( 'body' ).addClass( 'toggle-sidebar-active' );
                jQuery( bigSlideAPI.settings.menu ).attr( 'aria-hidden', 'false' );
            },
            afterClose: function() {
                jQuery( 'body' ).removeClass( 'toggle-sidebar-active' );
                jQuery( bigSlideAPI.settings.menu ).attr( 'aria-hidden', 'true' );
            },
        }).bigSlideAPI;

        jQuery( document.getElementById( 'close-toggle-sidebar' ) ).on( 'click', function(e) {
            e.preventDefault();
            bigSlideAPI.view.toggleClose();
        });
    });

    // Blog Layout
    jQuery( function() {
        var blogGrid = pageContainer.find( document.getElementById( 'archive-grid' ) );

        // Check if archive container is visible
        if ( blogGrid.length && jQuery.isFunction( jQuery.fn.masonry ) ) {
            blogGrid.imagesLoaded( function() {
                blogGrid.masonry( {
                    itemSelector: '.hentry',
                    isResizable: true,
                    isAnimated: true,
                    animationOptions: {
                        duration: 200
                    }
                });
            });

            setTimeout( function () {
                blogGrid.masonry( 'layout' );
            }, 1000 );
        }

    });
});
